#target photoshop

var panelInfo = {
    "panel_version": "4.0.0",
    "panel_name": "Delicious Retouch 4(OH汉化)",
    "panel_id": "DeliciousRetouch4",
    "author": "Chef",
    "contact_email": "photoshopchef@gmail.com"
};

var messages = {
    "success": "安装完成。现在重新启动 Photoshop!\n重新启动后, 您会发现 " + panelInfo.panel_name + " 在\n窗口 > 扩展 > " + panelInfo.panel_name,
    "fail": "安装失败 :-( \n您将需要手动安装扩展: \n1.: 打开 \"Manual_Installation\" 文件夹然后复制 \"" + panelInfo.panel_id + "\" \n2.: 粘贴 \"" + panelInfo.panel_id + "\" 文件夹至 \"extensions\" 文件夹. 该 \"extensions\" 此讯息后将自动打开文件夹.\n3.: 重新启动 Photoshop. 重启后, 你会发现该扩展在窗口 > 扩展 > " + panelInfo.panel_name + " \n有关手动安装和其他安装方法的详细信息, 请参阅包括 .pdf\n------------\nPS 版本: " + app.version + ", " + ($.os.match(/windows/i) ? "Win" : "Mac") + ". 出错:",
    "errors": []
};

var appVersion = checkAppVersion();
if (appVersion >= 14) {
    init();
} else {
    alert("此扩展需要 Adobe Photoshop CC 或更高.", "错误版本(OH汉化)", false);
}

function init() {
    var workDirs = getWorkDirectroies();
    var panelContent = getDirectoryContent(workDirs.from);

    if (workDirs.to.exists) {
        alert("我们发现旧版本的 " + panelInfo.panel_name + "\n您需要在安装之前删除它.\n1. 关闭 Photoshop\n2. 在此消息之后, 您将看到 Photoshop 扩展目录\n3. 寻找 '" + panelInfo.panel_id + "' 文件夹并将其删除\n4. 打开 Photoshop 并尝试再次安装","检测到旧版本(OH汉化)",false);
        workDirs.to.parent.execute();
        return false
    }

    createDirStructure(panelContent.folders, workDirs);

    copyFiles(panelContent.files, workDirs);

    if (messages.errors.length < 1) {
        /* Show success message */
        alert(messages.success, "完成!", false);
    } else {
        /* Show error message */
        var e;
        var errStr = "";
        var maxErrors = 3;
        maxErrors <= messages.errors.length ? maxErrors : messages.errors.length;
        for (e = 0; e < maxErrors; e++) {
            errStr += "\n" + messages.errors[e];
        }
        if (maxErrors < messages.errors.length) {
            errStr += "\nand " + (messages.errors.length - maxErrors) + " 出错..."
        }
        alert(messages.fail + " " + errStr, "出错", false);
        workDirs.to.parent.execute();
    }
}

function checkAppVersion() {
    var appv = parseInt(app.version, 10);
    return appv >= 14 ? appv : -1;
}

function getWorkDirectroies() {
    var d = {
        "from": new Folder((File($.fileName).path) + "/Manual_Installation/" + panelInfo.panel_id),
        "to": new Folder(Folder.userData + "/Adobe/" + (appVersion === 14 ? "CEPServiceManager4" : "CEP") + "/extensions/" + panelInfo.panel_id)
    };
    return d
}

function getDirectoryContent(_dir) {
    var j, list, item, innerFolderContent;
    var panelsContent = {
        "files": [],
        "folders": []
    };
    if (_dir.constructor === String) {
        _dir = new Folder(_dir);
    }
    list = _dir.getFiles();
    for (j = 0; j < list.length; j++) {
        item = list[j];
        if (item instanceof Folder) {
            panelsContent.folders.push(item);
            innerFolderContent = getDirectoryContent(item);
            panelsContent.files = panelsContent.files.concat(innerFolderContent.files);
            panelsContent.folders = panelsContent.folders.concat(innerFolderContent.folders);
        } else {
            panelsContent.files.push(item);
        }
    }
    return panelsContent
}

function createDirStructure(_folders, _dirs) {
    var p;
    for (p = 0; p < _folders.length; p++) {
        createDir(decodeURI(_dirs.to) + decodeURI(_folders[p].fsName).replace(_dirs.from.fsName, "").replace(/\\/g, "/"));
    }
}

function createDir(_path) {
    var res, f = _path;
    if (f.constructor === String) {
        f = new Folder(_path);
    }

    if (!f.parent.exists) {
        createDir(f.parent);
    }

    if (!f.exists) {
        res = f.create();
        if (!res) messages.errors.push("无法创建文件夹: " + f.fsName + "\n");
    }
}

function copyFiles(_files, _dirs) {
    var i, res, f;
    for (i = 0; i < _files.length; i++) {
        f = new File(decodeURI(_dirs.to.fsName) + decodeURI(_files[i].fsName).replace(_dirs.from.fsName, "").replace(/\\/g, "/"));
        res = _files[i].copy(f);
        if (!res) messages.errors.push("无法复制文件: " + f.fsName + "\n");
    }
}